<%@LANGUAGE="JSCRIPT"%><%
	// Created 01-Jan-2011 by AAGware as version A.00
	// Revised 23-Mar-2012 by AAGware as version E.00

	Response.ContentType = "text/plain"; // Plain text -> wikitext

	var oSh        =null;
	var oWS        =null;
	var oEX        =null;
	var oAux       =null;	

	var oFS        =null;
	var oFL        =null;
	var fDelayMsg  ="";
	var fDir       ="";			
	var fExtCW		 ="";
	var fExtWC		 ="";
	var n          =0;
	var s          ="";
	var sE         ="0";
	var sUS        ="knot";
	var flgWC      ="0";       //	=0 AAG_CLoudWatcher without anemoneter; =1 AAG_WeatherCenter; =2 AAG_CLoudWatcher with anemoneter; =3 Help
	var corBcgHdr  ="#4c4c4c"; // Header Background color
	var corOk      ="#00ff00"; // define forecolor for OK conditions (default = green)
	var corNotOk   ="#ff0000"; // define forecolor for NOT OK conditions (default=red)
	var corWarn    ="#ffffff"; // define forecolor for Warning conditions (defaut=orange)
	var corSAFEON  ="#aa0000"; // define forecolor of Unsafe button when down
	var corSAFEOFF ="#00aa00"; // define forecolor of Unsafe button when down
	
	var rqst = Request.ServerVariables("QUERY_STRING"); // can be: "request". "package", button id

	if (rqst!="Summary" && rqst!="Limits" && rqst!="Unsafe" && rqst!="Help" && rqst!="Version" && rqst!="Graphs") {
		if(!User.IsAdministrator) {
			Response.Write("Msg:Cannot perform this task - you must be an administrator");				// Should be impossible in UI
			Response.End();
		}
		if(Lock.Locked) {
			if(Lock.Owner != User.Name) {
				Response.Write("Msg:Cannot perform this task - the observatory is in use by " + Lock.Owner + ".\n");
				Response.End();
			}
		}
	}
	if (rqst=="Help") {
		flgWC="3";		
	} else {
		oSh = new ActiveXObject("WScript.Shell");	
		try {
			flgWC = oSh.RegRead("HKEY_CURRENT_USER\\Software\\VB and VBA Program Settings\\AAG_WeatherCenter\\Setup\\Emulator");
		} catch(ex) {
		  flgWC="0";
			}
		if (flgWC=="1") {
			try {
				oWS = new ActiveXObject("AAG_WeatherCenter.CloudWatcher");
			} catch(ex) {														// We have AAG_WeatherCenter
			    oWS = null;
			    flgWC="0";
					try {
						oWS = new ActiveXObject("AAG_CloudWatcher.CloudWatcher");
					} catch(ex) {
					    oWS = null;
					    flgWC="-1";
							Response.Write("Msg:AAG_CloudWatcher is not available.");
							Response.End();
					  }                                        
			  }																					// We have AAG_CloudWatcher
		} 
		else {
				try {
					oWS = new ActiveXObject("AAG_CloudWatcher.CloudWatcher");
				} catch(ex) {
				    oWS = null;
						flgWC="-1";
						Response.Write("Msg:AAG_CloudWatcher is not available.");
						Response.End();
					}				
		}
		if (flgWC=="0") {
			if (oWS.Version.substring(0,1)>="7") {
				if (oWS.AAG_IsWindPresent()==true) {
					flgWC="2";
				}				
			}
		}		
		oWS.Device_Start()
		while ((!oWS.DataReady()) && (n < 90000)){		// wait for device to start
			n++;
		}
		if (n>=30000) {																// timeout loop exceeded some problem with device
			Response.Write("Msg:Device is not ready.");
			Response.End();
		}

		if (Weather.Available) {
			sE=1;																				// 1 =  External server of the Weather Server is present 	
			try {
				oEX = new ActiveXObject("AAG_ACPWeatherFeed.Weather");
			} catch(ex) {
					sE = 0;																	// 0 =  External server of the Weather Server is not present 
			    oEX = null;
			}	
			if (oEX!=null) {
				if (!oEX.ExternalServer) { 
					sE=0;
				} else {
					try {
						oAux = oEX.ExternalServer;
					} catch(ex) {
							sE=0;																	// 0 =  External server of the Weather Server is not present 
					    oEX = null;
					}
				}
			}
		} else {
			sE=0;																					// 1 =  External server of the Weather Server is present 	
		}
		if (rqst=="Version") {
			if (flgWC=="1") {
				Response.Write("<small>WC" + " (v"+ oWS.Version +")&nbsp;&nbsp;&nbsp;&nbsp;CW" + " (v"+ oWS.VersionCW +")"+"</small>");
			} else {
				Response.Write("<small>CW" + " (v"+ oWS.Version +")"+"</small>");
			}
			Response.End();
		}
		if ((flgWC=="1")||(flgWC=="2")) {
			switch(oWS.UnitSpeed.substr(0,1)) {				  // We have AAG_WeatherCenter and it's connected
				case "K":
					sUS="km/h";
					break;
				case "M":
					sUS="mph";
					break;
				case "m":
					sUS="m/s";
					break;
				case "k":
					sUS="knot";
					break;
			}
		}		
		if (rqst!="Summary" && rqst!="Limits" && rqst!="Unsafe" && rqst!="Graphs") {
			switch(rqst) {
				case "bCloudClear":
						oWS.SafeClear = (oWS.SafeClear==0 ? 1 : 0);
					break;
				case "bCloudCloudy":
						oWS.SafeCloudy = (oWS.SafeCloudy==0 ? 1 : 0);
					break;
				case "bCloudVCloudy":
						oWS.SafeOvercast = (oWS.SafeOvercast==0 ? 1 : 0);
					break;
				case "bRainDry":
						oWS.SafeDry = (oWS.SafeDry==0 ? 1 : 0);
					break;
				case "bRainWet":
						oWS.SafeWet =  (oWS.SafeWet==0 ? 1 : 0);
					break;
				case "bRainRain":
						oWS.SafeRain = (oWS.SafeRain==0 ? 1 : 0);
					break;
				case "bWindCalm":
						oWS.SafeWindCalm = (oWS.SafeWindCalm==0 ? 1 : 0);
					break;
				case "bWindWindy":
						oWS.SafeWindWindy = (oWS.SafeWindWindy==0 ? 1 : 0);
					break;
				case "bWindVWindy":
						oWS.SafeWindVWindy = (oWS.SafeWindVWindy==0 ? 1 : 0);
					break;
				case "bGustCalm":
						oWS.SafeGustCalm = (oWS.SafeGustCalm==0 ? 1 : 0);
					break;
				case "bGustWindy":
						oWS.SafeGustWindy = (oWS.SafeGustWindy==0 ? 1 : 0);
					break;
				case "bGustVWindy":
						oWS.SafeGustVWindy = (oWS.SafeGustVWindy==0 ? 1 : 0);
					break;
				case "bDewFine":
						oWS.SafeDewFine = (oWS.SafeDewFine==0 ? 1 : 0);
					break;
				case "bDewHumid":
						oWS.SafeDewHumid = (oWS.SafeDewHumid==0 ? 1 : 0);
					break;
				case "bDewCondensation":
						oWS.SafeDewCondensation = (oWS.SafeDewCondensation==0 ? 1 : 0);
					break;
				case "bHumFine":
						oWS.SafeHumFine = (oWS.SafeHumFine==0 ? 1 : 0);
					break;
				case "bHumHumid":
						oWS.SafeHumHumid = (oWS.SafeHumHumid==0 ? 1 : 0);
					break;
				case "bHumVHumid":
						oWS.SafeHumVHumid = (oWS.SafeHumVHumid==0 ? 1 : 0);
					break;
				case "bTempCold":
						oWS.SafeTempCold = (oWS.SafeTempCold==0 ? 1 : 0);
					break;
				case "bTempFine":
						oWS.SafeTempFine = (oWS.SafeTempFine==0 ? 1 : 0);
					break;
				case "bTempHot":
						oWS.SafeTempHot = (oWS.SafeTempHot==0 ? 1 : 0);
					break;
				case "bLightDark":
						oWS.SafeDark = (oWS.SafeDark==0 ? 1 : 0);
					break;
				case "bLightLight":
						oWS.SafeLight = (oWS.SafeLight==0 ? 1 : 0);
					break;
				case "bLightVLight":
						oWS.SafeVLight = (oWS.SafeVLight==0 ? 1 : 0);
					break;
			}	
			rqst = "Unsafe";
		}	
    if (typeof(oWS.AAG_SafeDelayMsg)!="undefined") {
			fDelayMsg=oWS.AAG_SafeDelayMsg;
		} else {
			fDelayMsg="";
		}		
	}
	opCode();

	//*****************	
	function opCode() {
		switch(flgWC) {
			case "0":
				Response.Write(CodeCW());
				break;
			case "1":			
				Response.Write(CodeWC());
				break;
			case "2":			
				Response.Write(CodeCW());
				break;
			case "3":
				var s = "<TABLE><TR><TD>";
						s = s + "The checkboxes at the top define which panels of information are displayed.<br><br>";
						s = s + "The information refreshment cycle is controlled by the options at the bottom. Note that <span style='border:1px solid'>Refresh</span> forces an immediate refreshment of the information.<br><br>";
						s = s + "The information details of the panels depends on whether the information is obtained from <big>AAG_CloudWatcher</big> or <big>AAG_WeatherCenter</big>.<br><br>";
						s = s + "<span><u><big>&nbsp;WEATHER SUMMARY&nbsp;</big></u></span><br>";
						s = s + "The STATUS column displays the WEATHER status and the AAG_CloudWatcher device SWITCH status. If an external server is connected to AAG_ACPWeatherFeed weather server then its status is displayed too.<br><br>";
						s = s + "<span><u><big>&nbsp;THRESHOLD LIMITS&nbsp;</big></u></span><br>";
						s = s + "The threshold values, descriptions and colors correspond to those defined in LIMITS TAB of <big>AAG_CloudWatcher / AAG_WeatherCenter</big>.<br><br>";
						s = s + "<span><u><big>&nbsp;UNSAFE CONDITIONS&nbsp;</big></u></span><br>";
						s = s + "The <big>UNSAFE conditions</big> may be changed provided one has administrative rights and the observatory is not locked by another user. A condition is changed by simply clicking over it.<br><br>";						
						s = s + "<span><u><big>&nbsp;GRAPHS&nbsp;</big></u></span><br>";
						s = s + "The <big>GRAPHS</big> correspond to the graph images generated by <big>AAG_CloudWatcher / AAG_WeatherCenter</big>.<b><big> =>NB:</big></b> Clean the browser cache every now and then because the image files are left in the cache everytime the Graphs' panel is refreshed.<br><br>";
						s = s + "</TD></TR></TABLE>";
				Response.Write(s);
				break;
			default:
				Response.Write(flgWC);
				break
		}
	}
	function fmtCor(p1) {
		var s = ((p1 & 255) << 16) + (p1 & 65280) + ((p1 & 16711680) >> 16);
		var d = Util.FormatVar(s.toString(16),"000000");
		switch(d.length) {
			case 5:
				d = "0"    +d;
				break;
			case 4:
				d = "00"   +d;
				break;
			case 3:
				d = "000"  +d;
				break;
			case 2:
				d = "0000" +d;
				break;				
			case 1:
				d = "00000"+d;
				break;
		}
		return( d + "; COLOR:#000000" );
	}
	
	function fcCloud(p1) {	
		switch(oWS.Condition_Cloud()) {
			case 1:			
				return( (p1==1) ?  oWS.DescriptionClear   : oWS.AAG_DataDisplayed("color","cloud") );
				break;
			case 2:
				return( (p1==1) ?  oWS.DescriptionCloudy  : oWS.AAG_DataDisplayed("color","cloud") );
				break;
			case 3:
				return( (p1==1) ?  oWS.DescriptionVCloudy : oWS.AAG_DataDisplayed("color","cloud") );
				break;
			default:
				return( (p1==1) ?  "Unknown"							: oWS.AAG_DataDisplayed("color","default") );
				break;
		}
	}
	function fvCloud(p1) {
		return( (p1==1) ?  Util.FormatVar(oWS.SkyTemperature(), "0.0") + " " + oWS.AAG_TemperatureUnits : corWarn);
	}
	function fcDew(p1) {
		switch(oWS.Condition_DewCond())	{
			case 1:
				return( (p1==1) ?  oWS.DescDewCondensation   : oWS.AAG_DataDisplayed("color","dew") );
				break;
			case 2:
				return( (p1==1) ?  oWS.DescDewHumid       : oWS.AAG_DataDisplayed("color","dew") );
				break;
			case 3:
				return( (p1==1) ?  oWS.DescDewFine        : oWS.AAG_DataDisplayed("color","dew") );
				break;
			default:
				return( (p1==1) ?  "Unknown"							: oWS.AAG_DataDisplayed("color","default") );
				break;
		}
	}
	function fvDew(p1) {
		return( (p1==1) ?  Util.FormatVar(oWS.DewPointTemp(), "0.0") + " " + oWS.AAG_TemperatureUnits : corWarn);
	}
	function fvSwitch(p1) {
		switch(oWS.SwitchStatus()){
			case 1:
				return( (p1==1) ?  "Opened"   : corOk );
				break;
			default:
				return( (p1==1) ?  "Closed"   : corNotOk );
				break;
		}
	}
	function fcRain(p1) {	
		switch(oWS.Condition_Rain()) {
			case 1:			
				return( (p1==1) ?  oWS.DescriptionDry       : oWS.AAG_DataDisplayed("color","rain") );
				break;
			case 2:
				return( (p1==1) ?  oWS.DescriptionWet       : oWS.AAG_DataDisplayed("color","rain") );
				break;
			case 3:
				return( (p1==1) ?  oWS.DescriptionRain      : oWS.AAG_DataDisplayed("color","rain") );
				break;
			default:
				return( (p1==1) ?  "Unknown"								: oWS.AAG_DataDisplayed("color","default") );
				break;
		}
	}
	function fvRain(p1) {
		return( (p1==1) ?  Util.FormatVar(oWS.RainValue(), "0") + " cycles" : corWarn);
	}
	function fcHum(p1) {
		switch(oWS.Condition_HumCond())	{
			case 1:
				return( (p1==1) ?  oWS.DescHumFine        : oWS.AAG_DataDisplayed("color","humididty") );
				break;
			case 2:
				return( (p1==1) ?  oWS.DescHumHumid       : oWS.AAG_DataDisplayed("color","humididty") );
				break;
			case 3:
				return( (p1==1) ?  oWS.DescHumVHumid      : oWS.AAG_DataDisplayed("color","humididty") );
				break;
			default:
				return( (p1==1) ?  "Unknown"							: oWS.AAG_DataDisplayed("color","default") );
				break;
		}
	}
	function fvHum(p1) {
		return( (p1==1) ?  Util.FormatVar(oWS.HumidityRelative(), "0") + " %" : corWarn);
	}
	function fvWeather(p1) {
		if (oWS.Safe()) {
			return( (p1==1) ?  "Safe"    : corOk);
		}	else {		
			return( (p1==1) ?  "Unsafe"  : corNotOk);
		}	
	}

	function fcLight(p1) {	
		switch(oWS.Condition_Brightness()) {
			case 1:			
				return( (p1==1) ?  oWS.DescriptionDark       : oWS.AAG_DataDisplayed("color","brightnesss") );
				break;
			case 2:
				return( (p1==1) ?  oWS.DescriptionLight      : oWS.AAG_DataDisplayed("color","brightnesss") );
				break;
			case 3:
				return( (p1==1) ?  oWS.DescriptionVLight     : oWS.AAG_DataDisplayed("color","brightnesss") );
				break;
			default:
				return( (p1==1) ?  "Unknown"								 : oWS.AAG_DataDisplayed("color","default") );
				break;
		}
	}
	function fvLight(p1) {
		return( (p1==1) ?  Util.FormatVar(oWS.BrightnessValue(), "0") + " K" : corWarn);
	}
	function fcWind(p1) {
		switch(oWS.Condition_Wind())	{
			case 1:
				return( (p1==1) ?  oWS.DescWindCalm       : oWS.AAG_DataDisplayed("color","wind") );
				break;
			case 2:
				return( (p1==1) ?  oWS.DescWindWindy      : oWS.AAG_DataDisplayed("color","wind") );
				break;
			case 3:
				return( (p1==1) ?  oWS.DescWindVwindy     : oWS.AAG_DataDisplayed("color","wind") );
				break;
			default:
				return( (p1==1) ?  "Unknown"							: oWS.AAG_DataDisplayed("color","default") );
				break;
		}
	}
	function fvWind(p1) {
		return( (p1==1) ?  Util.FormatVar(oWS.WindValue(), "0.0") + " " + sUS : corWarn);
	}
	function fvExternal(p1) {
		if (sE==1) {
			if (oEX.SafeExternalServer) {
				return( (p1==1) ?  "Safe"    : "COLOR:" + corOk);
			} else {
				return( (p1==1) ?  "Unsafe"  : "COLOR:" + corNotOk);
			}
		} else {
			return( (p1==1) ?  "n/a"  : "");
		}
	}
	function fcTemp(p1) {	
		switch(oWS.Condition_Temp()) {
			case 1:			
				return( (p1==1) ?  oWS.DescTempCold       : oWS.AAG_DataDisplayed("color","temperature") );
				break;
			case 2:
				return( (p1==1) ?  oWS.DescTempFine       : oWS.AAG_DataDisplayed("color","temperature") );
				break;
			case 3:
				return( (p1==1) ?  oWS.DescTempHot        : oWS.AAG_DataDisplayed("color","temperature") );
				break;
			default:
				return( (p1==1) ?  "Unknown"							: oWS.AAG_DataDisplayed("color","default") );
				break;
		}
	}
	function fvTemp(p1) {
		return( (p1==1) ?  Util.FormatVar(oWS.AmbientTemperature(), "0.0") + " " + oWS.AAG_TemperatureUnits : corWarn);
	}
	function fcGust(p1) {
		switch(oWS.Condition_Gust())	{
			case 1:
				return( (p1==1) ?  oWS.DescGustCalm       : oWS.AAG_DataDisplayed("color","gust") );
				break;
			case 2:
				return( (p1==1) ?  oWS.DescGustWindy      : oWS.AAG_DataDisplayed("color","gust") );
				break;
			case 3:
				return( (p1==1) ?  oWS.DescGustVwindy     : oWS.AAG_DataDisplayed("color","gust") );
				break;
			default:
				return( (p1==1) ?  "Unknown"						  : oWS.AAG_DataDisplayed("color","default") );
				break;
		}
	}
	function fvGust(p1) {
		return( (p1==1) ?  Util.FormatVar(oWS.GustValue(), "0.0") + " " + sUS : corWarn);
	}
	function fvOverall(p1) {
		if (sE==1) {
			if (oEX.SafeExternalServer==1 && oWS.Safe()) {
				return( (p1==1) ?  "Safe"    : corOk);
			} else {
				return( (p1==1) ?  "Unsafe"  : corNotOk);
			}
		} else {
			if (oWS.Safe()) {
				return( (p1==1) ?  "Safe"    : corOk);
			} else {
				return( (p1==1) ?  "Unsafe"  : corNotOk);
			}
		}
	}
	function fvAtm(p1) {
		return( (p1==1) ?  Util.FormatVar(oWS.BarometricPressure(), "0") + " " + oWS.UnitsBarometricPressure() : corWarn);
	}
	function fvDir(p1) {
		return( (p1==1) ?  Util.FormatVar(oWS.WindDir(), "0.0") + " deg" : corWarn);
	}
	function fCopyFiles() {
		oFS = new ActiveXObject("Scripting.FileSystemObject");		
		if (oFS.FolderExists("aag_images")== true) { oFS.DeleteFolder("aag_images", true); }
		oFS.CreateFolder("aag_images");
		if (flgWC=="1") {
			fExtCW=".jpg";
			if (oWS.MForm().oCW.MForm().ImageType==1) { fExtCW=".png"; }
			fDir=oWS.MForm().oCW.GraphImagePath+"/";
			try {			
 				oFL = oFS.GetFile(fDir+"AAG_ImageCloudCondition"+fExtCW);
				oFL.Copy("aag_images/"+oFL.Name,true);
				oFL = oFS.GetFile(fDir+"AAG_ImageRainCondition"+fExtCW);
				oFL.Copy("aag_images/"+oFL.Name,true);
				oFL = oFS.GetFile(fDir+"AAG_ImageDayCondition"+fExtCW);
				oFL.Copy("aag_images/"+oFL.Name,true);
				oFL = oFS.GetFile(fDir+"AAG_ImageTemperature"+fExtCW);
				oFL.Copy("aag_images/"+oFL.Name,true);
			} catch(ex) {}
			fExtWC=".jpg";
			if (oWS.MForm().Imagetype==1) { fExtWC=".png"; }
			fDir=oWS.MForm().GraphImagePath+"/";
			try {
				oFL = oFS.GetFile(fDir+"AAG_ImageWindCondition"+fExtWC);
				oFL.Copy("aag_images/"+oFL.Name,true);
				oFL = oFS.GetFile(fDir+"AAG_ImageGustCondition"+fExtWC);
				oFL.Copy("aag_images/"+oFL.Name,true);
				oFL = oFS.GetFile(fDir+"AAG_ImageWindDirCondition"+fExtWC);
				oFL.Copy("aag_images/"+oFL.Name,true);
				oFL = oFS.GetFile(fDir+"AAG_ImageDewCondition"+fExtWC);
				oFL.Copy("aag_images/"+oFL.Name,true);
				oFL = oFS.GetFile(fDir+"AAG_ImageHumCondition"+fExtWC);
				oFL.Copy("aag_images/"+oFL.Name,true);
				oFL = oFS.GetFile(fDir+"AAG_ImageTempCondition"+fExtWC);
				oFL.Copy("aag_images/"+oFL.Name,true);
			} catch(ex) {}
		}	else {
			fExtCW=".jpg";
			if (oWS.MForm().ImageType==1) { fExtCW=".png"; }
			fDir=oWS.MForm().GraphImagePath+"/";
			try {
 				oFL = oFS.GetFile(fDir+"AAG_ImageCloudCondition"+fExtCW);
				oFL.Copy("aag_images/"+oFL.Name,true);			
				oFL = oFS.GetFile(fDir+"AAG_ImageRainCondition"+fExtCW);
				oFL.Copy("aag_images/"+oFL.Name,true);
				oFL = oFS.GetFile(fDir+"AAG_ImageDayCondition"+fExtCW);
				oFL.Copy("aag_images/"+oFL.Name,true);
				oFL = oFS.GetFile(fDir+"AAG_ImageTemperature"+fExtCW);
				oFL.Copy("aag_images/"+oFL.Name,true);
				oFL = oFS.GetFile(fDir+"AAG_ImageWIndCond"+fExtCW);
				oFL.Copy("aag_images/"+oFL.Name,true);
			} catch(ex) {}
		}		
		return("") ;
	}
	function CodeWC() {
		var s = "";
		var rndRad = 1000000*Math.random();
		switch( rqst ) {
			case "Summary":
				s = s + "<TABLE><TR><TD colspan='6' style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center'><b>Weather</b></TD><TD colspan='2' style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center'><b>Status</b></TD></TR>";
				s = s + "<TR><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Cloud</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
				s = s + fcCloud(2);
				s = s + "'>";
				s = s + fcCloud(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
				s = s + fvCloud(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Dewpoint</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
				s = s + fcDew(2);
				s = s + "'>";
				s = s + fcDew(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
				s = s + fvDew(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Switch</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
				s = s + fvSwitch(2);
				s = s + "'>";
				s = s + fvSwitch(1) +"</TD></TR>";
				s = s + "<TR><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Rain</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
				s = s + fcRain(2);
				s = s + "'>";
				s = s + fcRain(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
				s = s + fvRain(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Humidity</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
				s = s + fcHum(2);
				s = s + "'>";
				s = s + fcHum(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
				s = s + fvHum(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Weather</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
				s = s + fvWeather(2);
				s = s + "'>";
				s = s + fvWeather(1);
				s = s + "</TD></TR><TR><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Brightness</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
				s = s + fcLight(2);
				s = s + "'>";
				s = s + fcLight(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
				s = s + fvLight(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Wind</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
				s = s + fcWind(2);
				s = s + "'>";
				s = s + fcWind(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
				s = s + fvWind(1) + "</TD>";
				if (sE==1) {
				s = s + "<TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"' >External</TD><TD colspan='1' style='TEXT-ALIGN: center; ";
				s = s + fvExternal(2) + "'>" + fvExternal(1) + "</TD>";
				}
				s = s + "</TR><TR><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Temperature</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
				s = s + fcTemp(2);
				s = s + "'>";
				s = s + fcTemp(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
				s = s + fvTemp(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Gust</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
				s = s + fcGust(2);
				s = s + "'>";
				s = s + fcGust(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
				s = s + fvGust(1) + "</TD>";
				if (sE==1) {
				s = s + "<TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"' >Overall</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
				s = s + fvOverall(2) + "'>" + fvOverall(1) + "</TD>";
				}
				s = s + "</TR><TR><TD colspan='2' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Atmospheric Pressure</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
				s = s + fvAtm(1);
				s = s + "</TD><TD colspan='2' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Wind Direction</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
				s = s + fvDir(1) + "</TD></TR>";
				if (fDelayMsg!="") {
					s = s + "<TR><TD colspan='8' style='color:#ffaa00; TEXT-ALIGN: Center; BACKGROUND-COLOR:"+corBcgHdr+"'><b>"+ fDelayMsg + "</b></TD></TR>";
				}
				s = s + "</TABLE>";
				break;
			case "Limits":
				s = s + "<TABLE cellspacing='0' border='1' cellpadding='0'>";
				s = s + "<TR><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' ><b>Threshold Limits</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' ><b>Description</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' colspan='2'><b>Value</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' ><b>Units</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' ><b>Threshold Limits</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' ><b>Description</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' colspan='2'><b>Value</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' ><b>Wind Direction</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' ><b>Units</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' ><b>Threshold Limits</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' ><b>Description</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' colspan='2'><b>Value</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' ><b>Units</b></TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"' rowspan='4'>Cloud</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorClear)+"' >"+oWS.DescriptionClear+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshTempClear,"0.0")+"</TD><TD style='TEXT-ALIGN: center' rowspan='4'>"+oWS.AAG_TemperatureUnits+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"' rowspan='4'>Wind</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorWindCalm)  +"'>"+oWS.DescWindCalm  +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshWindCalm,  "0.0")+"</TD><TD style='TEXT-ALIGN: center'>"+oWS.DescDirWindCalm+"</TD><TD style='TEXT-ALIGN: center' rowspan='4'>"+sUS+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"' rowspan='4'>Dew</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorDewCondensation) +"'>"+oWS.DescDewCondensation +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshDewCondensation,"0")+"</TD></TD><TD style='TEXT-ALIGN: center' rowspan='4'>"+oWS.AAG_TemperatureUnits+"</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorCloudy)+"'>"+oWS.DescriptionCloudy+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshTempCloudy,"0.0")+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorWindWindy) +"'>"+oWS.DescWindWindy +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshWindWindy, "0.0")+"</TD><TD style='TEXT-ALIGN: center'>"+oWS.DescDirWindWindy+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorDewHumid)        +"'>"+oWS.DescDewHumid        +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshDewHumid,       "0")+"</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorVCloudy)+"'>"+oWS.DescriptionVCloudy+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshTempVCloudy,"0.0")+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorWindVWindy)+"'>"+oWS.DescWindVWindy+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshWindVWindy,"0.0")+"</TD><TD style='TEXT-ALIGN: center'>"+oWS.DescDirWindVWindy+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorDewFine)         +"'>"+oWS.DescDewFine         +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshDewFine,        "0")+"</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"' rowspan='4'>Rain</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorDry) +"'>"+oWS.DescriptionDry +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshRainDry, "#,##0")+"</TD></TD><TD style='TEXT-ALIGN: center' rowspan='4'>cycles</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"' rowspan='4'>Gust</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorGustCalm)  +"'>"+oWS.DescGustCalm  +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshGustCalm,  "0.0")+"</TD><TD style='TEXT-ALIGN: center'>"+oWS.DescDirGustCalm+"</TD><TD style='TEXT-ALIGN: center' rowspan='4'>"+sUS+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"' rowspan='4'>Humidity</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorHumFine)   +"'>"+oWS.DescHumFine    +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshHumFine,  "0")+"</TD><TD style='TEXT-ALIGN: center' rowspan='4'>%</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorWet) +"'>"+oWS.DescriptionWet +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshRainWet, "#,##0")+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorGustWindy) +"'>"+oWS.DescGustWindy +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshGustWindy, "0.0")+"</TD><TD style='TEXT-ALIGN: center'>"+oWS.DescDirGustWindy+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorHumHumid)  +"'>"+oWS.DescHumHumid   +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshHumHumid, "0")+"</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorRain)+"'>"+oWS.DescriptionRain+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshRainRain,"#,##0")+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorGustVWindy)+"'>"+oWS.DescGustVWindy+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshGustVWindy,"0.0")+"</TD><TD style='TEXT-ALIGN: center'>"+oWS.DescDirGustVWindy+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorHumVHumid) +"'>"+oWS.DescHumVHumid  +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshHumVHumid,"0")+"</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"' rowspan='4'>Brightness</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorDark)   +"'>"+oWS.DescriptionDark   +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshBrightnessDark,   "#,##0")+"</TD><TD style='TEXT-ALIGN: center' rowspan='4'>K</TD><TD style='TEXT-ALIGN: center' colspan='6' rowspan='3'>"+"All these parameters may be adjusted in the Limits TAB of <br />AAG_WeatherCenter / AAG_CloudWatcher;"+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"' rowspan='3'>Temperature</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorTempCold) +"'>"+oWS.DescTempCold  +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshTAmbCold, "0")+"</TD><TD style='TEXT-ALIGN: center' rowspan='4'>"+oWS.AAG_TemperatureUnits+"</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorLight)  +"'>"+oWS.DescriptionLight  +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshBrightnessLigth,  "#,##0")+"</TD></TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorTempFine) +"'>"+oWS.DescTempFine  +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshTAmbFine, "0")+"</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorVLight) +"'>"+oWS.DescriptionVLight +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshBrightnessVLigth, "#,##0")+"</TD></TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorTempHot)  +"'>"+oWS.DescTempHot   +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshTAmbHot,  "0")+"</TD></TR>";			
				s = s + "</TABLE>";
				break;
			case "Unsafe":
				s = s + "<TABLE id=TabUnsafe style='BACKGROUND-COLOR:"+corBcgHdr+"' border=1 cellSpacing=0 cellPadding=0 style='BORDER-COLLAPSE: collapse' borderColor=#000000 >";
				s = s + "<TR><TD colspan='4' style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'><font size='2'><b>Unsafe Conditions</b></font></TD></TR><TR>";
				s = s + "<TD style='TEXT-ALIGN: left; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'>Cloud</TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Clear")+" id=bCloudClear type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Cloudy")+" id=bCloudCloudy type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("VCloudy")+" id=bCloudVCloudy type=button /></TD></TR><TR>";
				s = s + "<TD style='TEXT-ALIGN: left; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'>Rain</TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Dry")+" id=bRainDry type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Wet")+" id=bRainWet type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Rain")+" id=bRainRain type=button /></TD></TR><TR>";
				s = s + "<TD style='TEXT-ALIGN: left; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'>Wind</TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("WindCalm")+" id=bWindCalm type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("WindWindy")+" id=bWindWindy type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("WindVWindy")+" id=bWindVWindy type=button /></TD></TR><TR>";
				s = s + "<TD style='TEXT-ALIGN: left; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'>Gust</TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("GustCalm")+" id=bGustCalm type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("GustWindy")+" id=bGustWindy type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("GustVWindy")+" id=bGustVWindy type=button /></TD></TR><TR>";
				s = s + "<TD style='TEXT-ALIGN: left; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'>DewPoint</TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("DewFine")+" id=bDewFine type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("DewHumid")+" id=bDewHumid type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("DewCondensation")+" id=bDewCondensation type=button /></TD></TR><TR>";
				s = s + "<TD style='TEXT-ALIGN: left; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'>Humidity</TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("HumFine")+" id=bHumFine type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("HumHumid")+" id=bHumHumid type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("HumVHumid")+" id=bHumVHumid type=button /></TD></TR><TR>"
				s = s + "<TD style='TEXT-ALIGN: left; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'>Temperature</TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("TempCold")+" id=bTempCold type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("TempFine")+" id=bTempFine type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("TempHot")+" id=bTempHot type=button /></TD></TR><TR>";
				s = s + "<TD style='TEXT-ALIGN: left; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'>Brightness</TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Dark")+" id=bLightDark type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Light")+" id=bLightLight type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("VLight")+" id=bLightVLight type=button /></TD></TR>";
				s = s + "</TABLE>";
				break;
			case "Graphs":
				s=fCopyFiles();
				s = s + "<TABLE id=TabGraph style='BACKGROUND-COLOR:"+corBcgHdr+"' border=1 cellSpacing=0 cellPadding=0 style='BORDER-COLLAPSE: collapse' borderColor=#000000 >";
				s = s + "<TR>";
				s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Cloud Conditions</TD>"
				s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Rain Conditions</TD>"
				s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Brightness Conditions</TD>"
				s = s + "</TR>";
				s = s + "<TR>";
				s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageCloudCondition"+fExtCW+"?"+rndRad+"' alt='Cloud Conditions'/></TD>";
				s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageRainCondition"+fExtCW+"?"+rndRad+"' alt='Rain Conditions'/></TD>";
				s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageDayCondition"+fExtCW+"?"+rndRad+"' alt='Brightness Conditions'/></TD>";
				s = s + "</TR>";				
				s = s + "<TR>";				
				s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Wind Conditions</TD>"
				s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Gust Conditions</TD>"
				s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Wind Direction</TD>"
				s = s + "</TR>";
				s = s + "<TR>";
				s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageWindCondition"+fExtWC+"?"+rndRad+"' alt='Wind Conditions'/></TD>";
				s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageGustCondition"+fExtWC+"?"+rndRad+"' alt='Gust Conditions'/></TD>";
				s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageWindDirCondition"+fExtWC+"?"+rndRad+"' alt='Wind Direction'/></TD>";
				s = s + "</TR>";
				s = s + "<TR>";				
				s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Dew Conditions</TD>"
				s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Humidity Conditions</TD>"
				s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Temperature Conditions</TD>"
				s = s + "</TR>";
				s = s + "<TR>";
				s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageDewCondition"+fExtWC+"?"+rndRad+"' alt='Dew Conditions'/></TD>";
				s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageHumCondition"+fExtWC+"?"+rndRad+"' alt='Humidity Conditions'/></TD>";
				s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageTempCondition"+fExtWC+"?"+rndRad+"' alt='Temperature Conditions'/></TD>";
				s = s + "</TR>";
				s = s + "</TABLE>";				
				break;
		}
		return(s);
	}
	function CodeCW() {
		var s = "";
		var rndRad = 1000000*Math.random();
		switch (rqst) {
			case "Summary":
				s = s + "<TABLE><TR><TD colspan='3' style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center'><b>Weather</b></TD><TD colspan='2' style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center'><b>Status</b></TD></TR>";
				s = s + "<TR><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Cloud</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR:#000000; BACKGROUND-COLOR:";
				s = s + fcCloud(2);
				s = s + "'>";
				s = s + fcCloud(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
				s = s + fvCloud(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Switch</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR:";
				s = s + fvSwitch(2);
				s = s + "'>";
				s = s + fvSwitch(1) + "</TD></TR>";
				s = s + "<TR><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Rain</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR:#000000; BACKGROUND-COLOR:";
				s = s + fcRain(2);
				s = s + "'>";
				s = s + fcRain(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
				s = s + fvRain(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Weather</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
				s = s + fvWeather(2);
				s = s + "'>";
				s = s + fvWeather(1);
				s = s + "</TD></TR>";
				if (flgWC=="2") {
					s = s + "<TR><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Wind</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR:#000000; BACKGROUND-COLOR:";
					s = s + fcWind(2);
					s = s + "'>";
					s = s + fcWind(1);
					s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
					s = s + fvWind(1) + "</TD>";
					if (sE==1) {
						s = s + "<TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"' >External</TD><TD colspan='1' style='TEXT-ALIGN: center; ";
						s = s + fvExternal(2) + "'>" + fvExternal(1) + "</TD>";
					}
					s = s + "</TR>";
				}
				s = s + "<TR><TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Brightness</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR:#000000; BACKGROUND-COLOR:";
				s = s + fcLight(2);
				s = s + "'>";
				s = s + fcLight(1);
				s = s + "</TD><TD colspan='1' style='TEXT-ALIGN: right  '>";
				s = s + fvLight(1) + "</TD>";
				if (flgWC!="2") {
					if (sE==1) {
						s = s + "<TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"' >External</TD><TD colspan='1' style='TEXT-ALIGN: center; ";
						s = s + fvExternal(2) + "'>" + fvExternal(1) + "</TD>";
					}
				} else {
					if (sE==1) {
						s = s + "<TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"' >Overall</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
						s = s + fvOverall(2) + "'>" + fvOverall(1) + "</TD>";
					}
				}
				s = s + "</TR><TR><TD colspan='2' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"'>Temperature</TD><TD style='TEXT-ALIGN: right'>";
				s = s + fvTemp(1)+ "</TD>";
				if (flgWC!="2") {
					if (sE==1) {
						s = s + "<TD colspan='1' style='TEXT-ALIGN: left; BACKGROUND-COLOR:"+corBcgHdr+"' >Overall</TD><TD colspan='1' style='TEXT-ALIGN: center; COLOR: ";
						s = s + fvOverall(2) + "'>" + fvOverall(1) + "</TD>";
					}
				}
				s = s + "</TR>";
				if (fDelayMsg!="") {
				  s = s + "<TR><TD colspan='5' style='color:#ffaa00; TEXT-ALIGN: Center; BACKGROUND-COLOR:"+corBcgHdr+"'><b>"+ fDelayMsg + "</b></TD></TR>";
				}				
				s = s + "</TABLE>";
				break;
			case "Limits":
				s = s + "<TABLE cellspacing='0' border='1' cellpadding='0'>";
				s = s + "<TR><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' ><b>Threshold Limits</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' ><b>Description</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' colspan='2'><b>Value</b></TD><TD style='BACKGROUND-COLOR:"+corBcgHdr+"; TEXT-ALIGN: center' ><b>Units</b></TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"' rowspan='4'>Cloud</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorClear)+"' >"+oWS.DescriptionClear+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshTempClear,"0.0")+"</TD><TD style='TEXT-ALIGN: center' rowspan='4'>"+oWS.AAG_TemperatureUnits+"</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorCloudy)+"'>"+oWS.DescriptionCloudy+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshTempCloudy,"0.0")+"</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorVCloudy)+"'>"+oWS.DescriptionVCloudy+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshTempVCloudy,"0.0")+"</TD></TR>";				
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"' rowspan='4'>Rain</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorDry) +"'>"+oWS.DescriptionDry +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshRainDry, "#,##0")+"</TD></TD><TD style='TEXT-ALIGN: center' rowspan='4'>cycles</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorWet) +"'>"+oWS.DescriptionWet +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshRainWet, "#,##0")+"</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorRain)+"'>"+oWS.DescriptionRain+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshRainRain,"#,##0")+"</TD></TR>";				
				if (flgWC=="2") {
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"' rowspan='4'>Wind</TD></TR>";				
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorCalm) +"'>"+oWS.DescWindCalm +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshWindCalm, "#,##0.00")+"</TD></TD><TD style='TEXT-ALIGN: center' rowspan='4'>"+sUS+"</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorWindy) +"'>"+oWS.DescWindWindy +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshWindWindy, "#,##0.00")+"</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorVWindy)+"'>"+oWS.DescWindVWindy+"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshWindVWindy,"#,##0")+"</TD></TR>";
				}
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"' rowspan='4'>Brightness</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorDark)   +"'>"+oWS.DescriptionDark   +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshBrightnessDark,   "#,##0")+"</TD><TD style='TEXT-ALIGN: center' rowspan='4'>K</TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorLight)  +"'>"+oWS.DescriptionLight  +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshBrightnessLigth,  "#,##0")+"</TD></TD></TR>";
				s = s + "<TR><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:#"+fmtCor(oWS.ColorVLight) +"'>"+oWS.DescriptionVLight +"</TD><TD style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+";'>&nbsp;&nbsp;<=&nbsp;&nbsp;</TD><TD style='TEXT-ALIGN: right'>"+Util.FormatVar(oWS.ThreshBrightnessVLigth, "#,##0")+"</TD></TD></TR>";
				s = s + "</TABLE>";
				break;
			case "Unsafe":
				s = s + "<TABLE id=TabUnsafe style='BACKGROUND-COLOR:"+corBcgHdr+"' border=1 cellSpacing=0 cellPadding=0 style='BORDER-COLLAPSE: collapse' borderColor=#000000 >";
				s = s + "<TR><TD colspan='4' style='TEXT-ALIGN: center; BACKGROUND-COLOR:"+corBcgHdr+"; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'><font size='2'><b>Unsafe Conditions</b></font></TD></TR><TR>";
				s = s + "<TD style='TEXT-ALIGN: left; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'>Cloud</TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Clear")+" id=bCloudClear type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Cloudy")+" id=bCloudCloudy type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("VCloudy")+" id=bCloudVCloudy type=button /></TD></TR><TR>";
				s = s + "<TD style='TEXT-ALIGN: left; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'>Rain</TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Dry")+" id=bRainDry type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Wet")+" id=bRainWet type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Rain")+" id=bRainRain type=button /></TD></TR><TR>";
				if (flgWC=="2") {
				s = s + "<TD style='TEXT-ALIGN: left; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'>Wind</TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("WindCalm")+" id=bWindCalm type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("WindWindy")+" id=bWindWindy type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("WindVWindy")+" id=bWindVWindy type=button /></TD></TR><TR>";				
				}
				s = s + "<TR><TD style='TEXT-ALIGN: left; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px'>Brightness</TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Dark")+" id=bLightDark type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("Light")+" id=bLightLight type=button /></TD>";
				s = s + "<TD><INPUT hideFocus style="+bUnsafe("VLight")+" id=bLightVLight type=button /></TD></TR>";
				s = s + "</TABLE>";
				break;
			case "Graphs":
				s=fCopyFiles();
				s = s + "<TABLE id=TabGraph style='BACKGROUND-COLOR:"+corBcgHdr+"' border=1 cellSpacing=0 cellPadding=0 style='BORDER-COLLAPSE: collapse' borderColor=#000000 >";
				s = s + "<TR>";
				s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Cloud Conditions</TD>"
				s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Rain Conditions</TD>"
				s = s + "</TR>";
				s = s + "<TR>";
				s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageCloudCondition"+fExtCW+"?"+rndRad+"' alt='Cloud Conditions'/></TD>";
				s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageRainCondition"+fExtCW+"?"+rndRad+"' alt='Rain Conditions'/></TD>";
				s = s + "</TR>";
				s = s + "<TR>";				
				if (flgWC=="2") {s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Wind Conditions</TD>";}
				s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Brightness Conditions</TD>";
				s = s + "<TD colspan='1' style='TEXT-ALIGN: center;'>Temperature</TD>";
				s = s + "</TR>";				
				s = s + "<TR>";
				if (flgWC=="2") {s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageWindCond"+fExtCW+"?"+rndRad+"' alt='Wind Conditions'/></TD>";}
				s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageDayCondition"+fExtCW+"?"+rndRad+"' alt='Brightness Conditions'/></TD>";
				s = s + "<TD><img border='0' src='ac/aag_images/AAG_ImageTemperature"+fExtCW+"?"+rndRad+"' alt='Temperature graph'/></TD>";
				s = s + "</TR>";
				s = s + "</TABLE>";
				break;
		}
		return(s);
	}	
	function bUnsafe(p1){
		var s   ="";
		var bOFF="'cursor:pointer;WIDTH: 98px; HEIGHT: 20px; FONT-SIZE: 12px; BACKGROUND-COLOR:"+corSAFEOFF+"; BORDER-BOTTOM: black 1px solid; BORDER-RIGHT: black 1px solid; BORDER-TOP: white 1px solid; BORDER-LEFT: white 1px solid;' name='aagButton'";
		var bON ="'cursor:pointer;WIDTH: 98px; HEIGHT: 20px; FONT-SIZE: 12px; BACKGROUND-COLOR:"+corSAFEON+"; BORDER-BOTTOM: white 1px solid; BORDER-RIGHT: white 1px solid; BORDER-TOP: black 1px solid; BORDER-LEFT: black 1px solid;'  name='aagButton'";
		switch(p1) {
			case "Clear":
					s = (oWS.SafeClear==0 ? bOFF : bON) + " value='" + oWS.DescriptionClear + "'";
				break;
			case "Cloudy":
					s = (oWS.SafeCloudy==0 ? bOFF : bON) + " value='" + oWS.DescriptionCloudy + "'";
				break;
			case "VCloudy":
					s = (oWS.SafeOvercast==0 ? bOFF : bON) + " value='" + oWS.DescriptionVCloudy + "'";
				break;
			case "Dry":
					s = (oWS.SafeDry==0 ? bOFF : bON) + " value='" + oWS.DescriptionDry + "'";
				break;
			case "Wet":
					s = (oWS.SafeWet==0 ? bOFF : bON) + " value='" + oWS.DescriptionWet + "'";
				break;
			case "Rain":
					s = (oWS.SafeRain==0 ? bOFF : bON) + " value='" + oWS.DescriptionRain + "'";
				break;
			case "WindCalm":
					s = (oWS.SafeWindCalm==0 ? bOFF : bON) + " value='" + oWS.DescWindCalm + "'";
				break;
			case "WindWindy":
					s = (oWS.SafeWindWindy==0 ? bOFF : bON) + " value='" + oWS.DescWindWindy + "'";
				break;
			case "WindVWindy":
					s = (oWS.SafeWindVWindy==0 ? bOFF : bON) + " value='" + oWS.DescWindVWindy + "'";
				break;
			case "GustCalm":
					s = (oWS.SafeGustCalm==0 ? bOFF : bON) + " value='" + oWS.DescGustCalm + "'";
				break;
			case "GustWindy":
					s = (oWS.SafeGustWindy==0 ? bOFF : bON) + " value='" + oWS.DescGustWindy + "'";
				break;
			case "GustVWindy":
					s = (oWS.SafeGustVWindy==0 ? bOFF : bON) + " value='" + oWS.DescGustVWindy + "'";
				break;
			case "DewFine":
					s = (oWS.SafeDewFine==0 ? bOFF : bON) + " value='" + oWS.DescDewFine + "'";
				break;
			case "DewHumid":
					s = (oWS.SafeDewHumid==0 ? bOFF : bON) + " value='" + oWS.DescDewHumid + "'";
				break;
			case "DewCondensation":
					s = (oWS.SafeDewCondensation==0 ? bOFF : bON) + " value='" + oWS.DescDewCondensation + "'";
				break;
			case "HumFine":
					s = (oWS.SafeHumFine==0 ? bOFF : bON) + " value='" + oWS.DescHumFine + "'";
				break;
			case "HumHumid":
					s = (oWS.SafeHumHumid==0 ? bOFF : bON) + " value='" + oWS.DescHumHumid + "'";
				break;
			case "HumVHumid":
					s = (oWS.SafeHumVHumid==0 ? bOFF : bON) + " value='" + oWS.DescHumVHumid + "'";
				break;
			case "TempCold":
					s = (oWS.SafeTempCold==0 ? bOFF : bON) + " value='" + oWS.DescTempCold + "'";
				break;
			case "TempFine":
					s = (oWS.SafeTempFine==0 ? bOFF : bON) + " value='" + oWS.DescTempFine + "'";
				break;
			case "TempHot":
					s = (oWS.SafeTempHot==0 ? bOFF : bON) + " value='" + oWS.DescTempHot + "'";
				break;
			case "Dark":
					s = (oWS.SafeDark==0 ? bOFF : bON) + " value='" + oWS.DescriptionDark + "'";
				break;
			case "Light":
					s = (oWS.SafeLight==0 ? bOFF : bON) + " value='" + oWS.DescriptionLight + "'";
				break;
			case "VLight":
					s = (oWS.SafeVLight==0 ? bOFF : bON) + " value='" + oWS.DescriptionVLight + "'";
				break;
		}
		return s;
	}
%>
