<%@LANGUAGE="JSCRIPT"%>
<script language="JScript" type="text/jscript" runat="server">
    //
    // AJAX support for System Status display (AJAX)
    //
    // The following format codes are supported by the system monitor
    // item, for display style changing:
    //
    //  @an - active no flash
    //  @af - active, flashing
    //  @wn - warning, no flash
    //  @wf - warning, flashing
    //  @in - off (inactive) never flashes
    //  @if - same as @in, never flashes
    //
    // 06-Oct-06    rbd Initial edit
    // 10-Oct-06    rbd Much work over last few days, add formatting codes
    //              change names.
    // 02-Nov-06    rbd Major upgrade, dome controls, UTC display
    // 03-Nov-06    rbd Always use Server.MapPath() for paths!
    // 04-Nov-06    rbd Display filter even if imager is idle.
    // 06-Nov-06    rbd Extend weather display
    // 08-Nov-06    rbd Add C to temp, change deg. to  on slew dist.
    // 09-Nov-06    rbd Send thumbnail link only when thumbnail changes.
    // 15-Nov-06    rbd Prevent target = "undefined". Prevent preposterous
    //              camera temperature. Show owner's real name if using 
    //              locally.
    // 20-Nov-06    rbd Add selective auto-scroll of run log disply (only
    //              when busy. Add new busy state "utility script" when not
    //              observing but a script is running. Display name of script.
    // 28-Nov-06    Add Conn/Disc links to Telescope and Imager column headers
    // 29-Nov-06    Don't even send new console text unless called with 'init'
    //              query string or a script is running. This prevents refreshing
    //              the log text (and jump-scrolling) when there is nothing
    //              going on, and still refreshes it when the tiddler is opened.
    //              Fix displays for shutter and dome when not available. Disable
    //              conn/disc links when script running. Change tooltips on
    //              disc links to "shut down", now park, warm, etc. Add visibility
    //              controls to several items. Change weather link to conn/disc.
    //              Add cooler and temp control to temperature label.
    // 01-Dec-06    Add dynamic Owner label/link
    // 03-Dec-06    Change to new LightBox for error popup and last image display
    // 05-Dec-06    Add power % to cooler display, adjust table cells for imager 
    //              column to make more space. On plan end, warn of compiler errors
    //              and if no JPEG, alert end of plan.
    // 06-Dec-06    Fix conversion of Observatory Owner to real local user name.
    // 11-Dec-05    Bulletproof detection of planEnded and scriptEnded, eliminating
    //              the timing window (well at least if it takes less than 6 sec to
    //              get a script started. New parking can cause scope to spontaneously
    //              disconn, so trap that in the telemetry displays.
    // 20-Jan-07    Move LST to Observatory, use ACP's Sidereal time property so it
    //              is available whether scope is connected or not. Add relative air
    //              mass to Telescope section.
    // 21-Jan-07    Catch display problem (raised error) when scope is being parked 
    //              and vaporizes.
    // 03-Apr-08    Report binning as X:Y instead of X:1.
    // 13-Apr-08    Report observatory "available" even if dome is closed, parked, etc.
    // 08-May-08    Air mass to three decimal places, alt/az to two decimal places. Guiding
    //              display even if disabled in ACP (#autoguide override directive).
    // 09-Jan-09    Fix Dome display for domes that don't have a shutter.
    // 25-Oct-09    GEM:129 Thumbnails and popup image now PNG. GEM:254 Add uniquify string 
    //              to ~lastimg.png for lightbox popup to avoid browser caching, new logic
    //              from AcquireImages to allow proper sizing of lightbox to preview image.
    //              GEM:260 Preview thumbnail hyperlink opens lightbox instead of popup.
    // 26-Oct-09    Further improvements to thumbnail and popup handling. See comments in
    //              that part of the code.
    // 28-Sep-10    GEM:458 - Increase wind threshold to 8 knots.
    // 04-Oct-10    (6.0) GEM:253 - now using AcquireImages.js via consolidated
    //              scripts directory.
    // 15-Nov-10    (6.0) GEM:97 Add Last FWHM to display. GEM:262 Add guider exposure to
    //              display. Fix binning to show "-:-" when idle not n/a. GEM:118, more
    //              additions, this time plan progress items.
    // 16-Nov-10    (6.0) GEM:118 more reorganization, adding tracking error graph. GEM:489
    //              change binning display to n:1. Simlify annunciator logic via defaults.
    //              Change camera Shutter Closed to Idle.
    // 17-Nov-10    (6.0) GEM:118 Mild refactoring. GEM:88 Shared preview images, guider
    //              preview, tracking graph.
    // 18-Nov-10    (6.0) Increase guider trackbox pic to 48x48 pixels.
    // 19-Nov-10    (6.0) Add GEM pointing state to Telescope section. Fix tracking graph
    //              time scaling. Now shows 8 min.
    // 20-Nov-10    (6.0) GEM:200 Enhance display for AutoFlat.
    // 22-Nov-10    (6.0) GEM:200 Oops, fix this for missing else.
    // 27-Nov-10    (6.0) From Erik Young, quote the plan name in the header
    // 20-Dec-10    (6.0) GEM:536 Show guider graph any time guiding is active, whether or
    //              not autoguiding in ACP is enabled (e.g. #autoguide directive).
    // 05-May-11    (6.0HF1) GEM:635 - Do not touch Guider XError or GuiderYError until the
    //              exposure is in progress. Avoid timing issues while waiting for guider
    //              error measurements during start of exposure process.
    // 25-Aug-11    (6.0HF2) GEM:314 - Support for both AcquireImages and AcquireScheduler, 
    //              refactoring of tracking graph data silo into AcquireSupport.
    // 26-Aug-11    (6.0HF2) GEM:494 - Scatter plot for guiding errors
    // 28-Aug-11    (6.0HF2) Triple guide errors when simulating, correct lint warnings (!!)
    //
    
    // -----------------
    // Support functions
    // -----------------
    
    //----------------------------------------------------------------------------------------
    //
    // ---------
    // airmass() - Get airmass for given zenith distance
    // ---------
    //
    // a = altitude (degrees)
    //
    // Uses Hardie's (1962) polynomial fit to Bemporad's data for
    // the relative air mass, X, in units of thickness at the zenith
    // as tabulated by Schoenberg (1929). This is adequate for all
    // normal needs as it is accurate to better than 0.1% up to X =
    // 6.8 and better than 1% up to X = 10. Bemporad's tabulated
    // values are unlikely to be trustworthy to such accuracy
    // because of variations in density, pressure and other
    // conditions in the atmosphere from those assumed in his work.
    //
    // Zenith Distance is limited to 87 deg to avoid overflow.
    //
    // References:
    //   Hardie, R.H., 1962, in "Astronomical Techniques"
    //       ed. W.A. Hiltner, University of Chicago Press, p180.
    //   Schoenberg, E., 1929, Hdb. d. Ap.,
    //       Berlin, Julius Springer, 2, 268.
    // 
    // Adapted from original Fortran code by P.W.Hill, St Andrews, C by P.T.Wallace.
    // Used by public AirMass()  method and also for Newton-Raphson solving to
    // back into zenith distance from given airmass (ZDFromAirMass())
    //----------------------------------------------------------------------------------------
    function airmass(a)
    {
        var z = Math.abs(90.0 - a) * Math.PI / 180.0;   // ZD in radians
        if(z > 1.52) z = 1.52;                          // Limit z to 87 degrees
        var szm1 = (1.0 / Math.cos(z)) - 1.0;
        return(1.0 + (szm1 * (0.9981833 - (szm1 * (0.002875 + (szm1 * 0.0008083))))));
    }

    //
    // getWeatherStatus() - Format weather summary
    //
    function getWeatherStatus()
    {
        if(!Weather.Available)
            return "@inn/a";
            
        try {
            if(Weather.Precipitation)
                return("@wnRain");                                          // Rain is always unsafe
                
        } catch(ex) { }
//----------------------- AAG modification BEGIN
		var C;
		try {
			C = new ActiveXObject("AAG_ACPWeatherFeed.Weather");
		} catch(ex) {
		    C = null;
				Response.Write("AAG_ACPWeatherFeed is not available.\n\n");
				Response.End();
		}																							// We have AAG_CloudWatcher and it's connected
		var ret = "";
		try {
			ret = C.WeatherDescription()
		} catch(ex) {
		    ret="Error - Incorrect version";
		}		
//		
//        var clouds = null;                                                  // [sentinel]
//        var wind = null;                                                    // [sentinel]
//        try {
//            clouds = Weather.Clouds;
//        } catch(ex) { }
//        try {
//            wind = Weather.WindVelocity;
//        } catch(ex) { }
//
//        var ret = "";
//        if(clouds !== null) {
//            if(clouds < 0.2)
//                ret += "Clear";
//            else
//                ret += "Clouds";
//        }
//        if(clouds !== null && wind !== null)
//            ret += " ";
//        if(wind !== null) {
//            if(wind < 8.0)
//                ret += "Calm";
//            else
//                ret += "Wind";
//        }
//----------------------- AAG modification END
        if(Weather.Safe) {
            if(ret === "") ret = "OK";
            ret = "@an" + ret;
        } else {
            if(ret === "") ret = "Unsafe";
            ret = "@wn" + ret;
        }
            
        return ret;
    }
    
    //
    // Limit the length of a string 'str' to 'max' characters. Return limited string.
    // No ellipsis '...' processing here, just chop the string.
    //
    function limitString(str, max)
    {
        if(str.length > max)
            return str.substr(0, max);
        else
            return str;
    }
    //  ===========
    //  MAIN SCRIPT
    //  ===========
    
    Response.ContentType = "text/json";                                     // We return JSON
    var FSO = new ActiveXObject("Scripting.FileSystemObject");
    var scrAct = Util.ScriptActive;                                         // Just a shortcut used in lots of places
    var SUP = null;                                                         // Valid only if script running and SUP available from script
    if(scrAct) {
        try {
            SUP = Util.Script.SUP;
        } catch(ex) {
            SUP = null;
        }
    }
    
    var camConn = false;                                                    // Need this for Obs too
    try {
        camConn = Camera.LinkEnabled;
    } catch(ex) { 
        camConn = false;
    }
    
    var scriptName = FSO.GetBaseName(Console.Script);                       // Name of executing script
    
    //  ---------------------------------------
    //  Observatory, Weather, Dome, and Shutter
    //  ---------------------------------------
    var obsStat;
    var obsLoc;
    var obsUTC;
    var obsST;
    var obsOwner;
    var obsOwnerLabel = "Owner";
    var obsWeather;
    var obsWeatherLabel = "Weather";
    var obsShutter;
    var obsShutterLabel;
    var obsShutterVis;
    var obsDome;
    var obsDomeLabel;
    var obsDomeVis;
    var obsNoShutterOrOpen = (!Dome.CanSetShutter || (Dome.CanSetShutter && Dome.ShutterStatus === 0));
    var obsOfferDomeOps = (!scrAct && obsNoShutterOrOpen);    

    //
    // LOGIC REPEATED IN SEVERAL ASP SCRIPTS
    //
    if(Telescope.Connected && camConn && (!Weather.Available || Weather.Safe))
    {
        if(Lock.Locked) {
            obsStat = "@anIn use";
        } else {
            if(Dome.Available) {
                if(Dome.CanSetShutter && Dome.ShutterStatus !== 0)
                    obsStat = "@anReady (closed)";  // Might be a roof!
                else if(Dome.CanSlew && (Dome.AtPark || Dome.AtHome || !Dome.Slaved))
                    obsStat = "@anReady (dome noslave)";
                else
                    obsStat = "@anReady";
            } else {
                obsStat = "@anReady";
            }
        }
    }
    else
        obsStat = "@wnOffline";

    obsLoc = "@an" + Util.FormatVar(new Date().getVarDate(), "hh:nn:ss");
    obsUTC = "@an" + Util.FormatVar(Util.SysUTCDate, "hh:nn:ss");
    obsST = "@an" + Util.Hours_HMS(Telescope.SiderealTime);                 // Telescope need not be connected
    
    if(Lock.Locked) {
        if(Lock.Owner == "Observatory Operator")                            // Show local owner's real name
            obsOwner = "@an" + limitString(Prefs.LocalUser.Name, 12);
        else
            obsOwner = "@an" + limitString(Lock.Owner, 12);                                  // Web owner
        if(!scrAct && ((Lock.Owner == User.Name) || User.IsAdministrator))  // Owner or admin can unlock
            obsOwnerLabel = "<a href=\"javascript:;\" id=\"sm_logOff\" " +
                                        "title=\"Click to release the observatory\">Owner</a>";
    } else {
        obsOwner = "@anFree";
    }

    if(Weather.Available)
    {
        obsWeather = getWeatherStatus();
        if(User.IsAdministrator) {
            if(!scrAct)
                obsWeatherLabel = "<a href=\"javascript:;\" id=\"sm_wxCtlLink\" op=\"disc\" " + 
                                        "title=\"Click to disconnect weather\">Weather</a>";
        } 
    }
    else
    {
        obsWeather = "@inn/a";
        if(User.IsAdministrator) {
            if(!scrAct)
                obsWeatherLabel = "<a href=\"javascript:;\" id=\"sm_wxCtlLink\" op=\"conn\" " + 
                                        "title=\"Click to connect weather\">Weather</a>";
        }
    }
    
    if(Dome.Available)
    {
        if(Dome.CanSetShutter)
        {
            obsShutterVis = true;
            var shutType;
            if(Dome.Available && !Dome.CanSlew)
                shutType = "Roof";
            else
                shutType = "Shutter";
            switch(Dome.ShutterStatus)                                      // Note 'op' attributes, sent to ashutterCtl.asp
            {
                case 0:
                    obsShutter = "@anOpen";
                    if(scrAct)
                        obsShutterLabel = shutType;
                    else
                        obsShutterLabel = "<a href=\"javascript:;\" id=\"sm_shutterCtlLink\" op=\"close\" title=\"Click to close the " + 
                                        shutType.toLowerCase() + "\">" + shutType + "</a>";
                    break;
                case 1:
                    obsShutter = "@wnClosed";
                    if(scrAct)
                        obsShutterLabel = shutType;
                    else
                        obsShutterLabel = "<a href=\"javascript:;\" id=\"sm_shutterCtlLink\" op=\"open\" title=\"Click to open the " + 
                                        shutType.toLowerCase() + "\">" + shutType + "</a>";
                    break;
                case 2:
                    obsShutter = "@afOpening";
                    obsShutterLabel = shutType;
                    break;
                case 3:
                    obsShutter = "@wfClosing";
                    obsShutterLabel = shutType;
                    break;
                case 4:
                    obsShutter = "@wnError";
                    if(scrAct)
                        obsShutterLabel = shutType;
                    else
                        obsShutterLabel = "<a href=\"javascript:;\" id=\"sm_shutterCtlLink\" op=\"close\" " + 
                                        "title=\"Click to FORCE-close the " + 
                                        shutType.toLowerCase() + "\">" + shutType + "</a>";
                    break;
                default:
                    break;
            }
        }
        else
        {
            // Why would this ever really be the case?? Oh well...
            obsShutterVis = false;                                          // Omit shutter/roof
            obsShutter = "@inn/a";                                          // Don't clear the <span>!!!!!
            obsShutterLabel = "Shutter";
        }
        
        //
        // This is a complex mess...
        //
        if(Dome.CanSlew)
        {
            obsDomeVis = true;
            if(Dome.Slewing) {                                              // Order is vital here!
                obsDome = "@afSlew";
                if(scrAct)
                    obsDomeLabel = "Dome";
                else
                    obsDomeLabel = "<a href=\"javascript:;\" id=\"sm_domeCtlLink\" op=\"stop\" " + 
                                    "title=\"Click to stop and unslave the dome\">Dome</a>";
            } else { 
                if(Dome.AtPark) {
                    obsDome = "@wnPark";
                    if(obsOfferDomeOps)
                        obsDomeLabel = "<a href=\"javascript:;\" id=\"sm_domeCtlLink\" op=\"unpark\" " + 
                                        "title=\"Click to unpark and slave the dome\">Dome</a>";
                    else
                        obsDomeLabel = "Dome";
                } else {
                    if(Dome.AtHome) {
                        obsDome = "@wnHome";
                        if(obsOfferDomeOps)
                            obsDomeLabel = "<a href=\"javascript:;\" id=\"sm_domeCtlLink\" op=\"unhome\" " + 
                                            "title=\"Click to unhome and slave the dome\">Dome</a>";
                        else
                            obsDomeLabel = "Dome";
                    } else {
                        // TODO - Remove this hack once Dome.Slave is fixed.
                        // NOTE - This does not show Slave if the "slave while closed" option is set... so what?
                        if(Dome.Slaved && obsNoShutterOrOpen)               // ACP Quirk: reports slaved when shutter closed, but doesn't slave!
                        {
                            obsDome = "@anSlave";
                            if(!scrAct) {
                                if(Dome.CanPark)                            // Precedence mirrors that in ACP, Park preferred over Home
                                    obsDomeLabel = "<a href=\"javascript:;\" id=\"sm_domeCtlLink\" op=\"park\" " + 
                                                    "title=\"Click to unslave and park the dome\">Dome</a>";
                                else if(Dome.CanFindHome)
                                    obsDomeLabel = "<a href=\"javascript:;\" id=\"sm_domeCtlLink\" op=\"home\" " + 
                                                    "title=\"Click to unslave and home the dome\">Dome</a>";
                                else
                                    obsDomeLabel = "<a href=\"javascript:;\" id=\"sm_domeCtlLink\" op=\"unslave\" " + 
                                                    "title=\"Click to unslave the dome\">Dome</a>";
                            } else {
                                obsDomeLabel = "Dome";
                            }
                        } else {
                            obsDome = "@wnStopped";
                            if(!scrAct) {
                                if(obsNoShutterOrOpen) {                    // If (no shutter or open) and unslaved, offer to slave
                                    obsDomeLabel = "<a href=\"javascript:;\" id=\"sm_domeCtlLink\" op=\"reslave\" " + 
                                                    "title=\"Click to enable dome slaving\">Dome</a>";
                                } else {                                    // Otherwise offer to park or home (no unslave msg this time)
                                    if(Dome.CanSetPark)                     // Precedence mirrors that in ACP, Park preferred over Home
                                        obsDomeLabel = "<a href=\"javascript:;\" id=\"sm_domeCtlLink\" op=\"park\" " + 
                                                        "title=\"Click to park the dome\">Dome</a>";
                                    else if(Dome.CanFindHome)
                                        obsDomeLabel = "<a href=\"javascript:;\" id=\"sm_domeCtlLink\" op=\"home\" " + 
                                                        "title=\"Click to home the dome\">Dome</a>";
                                }
                            } else {
                                obsDomeLabel = "Dome";
                            }
                        }
                    }
                }
            }
        }
        else
        {
            obsDomeVis = false;
            obsDome = "@inn/a";
            obsDomeLabel = "Dome";
        }
    }
    else                                                                    // No dome or roof at all
    {
        obsShutterVis = false;
        obsShutter = "@inn/a";
        obsShutterLabel = "Shutter";
        obsDomeVis = false;
        obsDome = "@inn/a";
        obsDomeLabel = "Dome";
    }

    //  ---------
    //  Telescope
    //  ---------
    var scopeHdr;
    var scopeStat = "@wnOffline";
    var scopeRA = "@in--:--:--.--";
    var scopeDec = "@in-----'--.-\"";
    var scopeAz = "@in---.--";
    var scopeAlt = "@in--.--";
    var gemVis = false;
    var scopeGEM = "@inn/a";
    var scopeAirMass = "@in--.---";
    var rotVis;
    var rotPA;
    if(FSO.FileExists(ACPApp.Path + "\\RotatorInfo.txt")) {
        rotVis = true;
        rotPA = "@in---";
    } else {
        rotVis = false;
        rotPA = "@inn/a";
    }
    
    var slewProg = 0;                                                       // Almost always 0
    
    if(User.IsAdministrator && !scrAct)                                     // Admins can conn/disc if no script running
    {
        if(Telescope.Connected) {
            scopeHdr = "<a href=\"javascript:;\" id=\"sm_scopeConnLink\" op=\"disc\" " +
                            "title=\"Click to shut down the telescope";
            if(Dome.Available) scopeHdr += " and dome";
            scopeHdr += "\">Telescope</a>";
        } else {
            scopeHdr = "<a href=\"javascript:;\" id=\"sm_scopeConnLink\" op=\"conn\" " +
                            "title=\"Click to connect the telescope";
            if(Dome.Available) scopeHdr += " and dome";
            scopeHdr += "\">Telescope</a>";
        }
    }
    else
        scopeHdr = "Telescope";                                             // Uses cannot conn/disc
    
    if(Telescope.Connected) 
    {
        try {
            scopeRA = "@an" + Util.Hours_HMS(Telescope.RightAscension, ":", ":", "", 2);
            scopeDec = "@an" + Util.Degrees_DMS(Telescope.Declination, "\u00B0","'", "\"", 1);
            scopeAz = "@an" + Util.FormatVar(Telescope.Azimuth, "000.00");
            var rawAlt = Telescope.Altitude;
            scopeAlt = "@an" + Util.FormatVar(rawAlt, "00.00");
            if(Telescope.AlignmentMode == 2)
            {
                gemVis = true;
                if(Telescope.SideOfPier === 0)
                    scopeGEM = "@anWest";
                else
                    scopeGEM = "@anEast";
            }
            scopeAirMass = "@an" + Util.FormatVar(airmass(rawAlt), "0.000");
            if(SUP) {
                if(Telescope.Slewing) {
                    scopeStat = "@afSlew " + Util.FormatVar(SUP.SlewDistance, "0.0") + "";
                    slewProg = SUP.SlewProgress;
                } else if(SUP.DoingOffsetTracking)
                    scopeStat = "@anOrbital Track";
                else if(Telescope.Tracking)
                    scopeStat = "@anSidereal Track";
                else
                    scopeStat = "@anStopped";
            } else {
                if(Telescope.Tracking)
                    scopeStat = "@anSidereal Track";
                else
                    scopeStat = "@anStopped";
            }
        } catch(ex) { }
    } 
    
    //
    // Rotator: Available only when SUP script runs (at least for now!)
    //
    if(rotVis && SUP && SUP.HaveRotator) {
        if(SUP.RotatorMoving) {
          rotPA = "@afRotate";
        } else {
            //
            // This depends on the scope's pier side. If the scope is being
            // parked from a script, SUP may be valid but Telescope might not
            // be connected. That scenario will raise an error here. Catch it.
            // If an error is raised, rotPA will still be "@in---" from above.
            //
            try {
                rotPA = "@an" + Util.FormatVar(SUP.RotatorPositionAngle, "000");
            } catch(ex) { }
        }
    }
    
    //  -----------------
    //  Imager and Guider
    //  -----------------
    var camHdr = "Imager";
    var camStat = "@wnOffline";
    var imgFilt = "@inn/a";
    var imgFiltVis = false;
    var imgBin = "@in-:-";
    var imgTemp = "@inn/a";
    var imgTempLabel = "Cooler";
    var imgTempVis = false;
    var guideTemp;
    var guideErrX = "@in--.--";
    var guideErrY = "@in--.--";
    var guideInt = "@in--.--";
    var guideStat;
    var guideVis;
    var gex;
    var gey;
    if(Prefs.Autoguiding.Enabled) {
        guideVis = true;
        guideStat = "@wnOffline";
    } else {
        guideVis = false;
        guideStat = "@inn/a";
    }
    var expProg = 0;                                                        // Almost always 0
    
    if(User.IsAdministrator && !scrAct)                                     // Admins can conn/disc if no script running
    {
        if(camConn) {
            camHdr = "<a href=\"javascript:;\" id=\"sm_camConnLink\" op=\"disc\" " +
                        "title=\"Click to shut down the imager\">Imager</a>";
        } else {
            camHdr = "<a href=\"javascript:;\" id=\"sm_camConnLink\" op=\"conn\" " +
                        "title=\"Click to connect the imager\">Imager</a>";
        }
    }

    if(camConn)                                                             // Determined at beginning
    {
        var fns = null;                                                     // [sentinel]
        camStat = "@anIdle";
        if(Camera.FilterWheelName != "No Filter Wheel")                     // If have filters
            fns = new VBArray(Camera.FilterNames).toArray();

        if(fns) {
            imgFiltVis = true;
            imgFilt = "@an" + fns[Camera.Filter];
        }
        
        imgBin = "@an" + Camera.BinX + ":1";
        
        if(SUP) {
            if(SUP.AutoFocusActive) {
                camStat = "@afAutofocus Busy";
            } else {
                if(scriptName.toLowerCase() == "autoflat") {
                    camStat = "@an(Short Exposures)";
                } else {
                    if(SUP.ExposureActive) {
                        camStat = "@afExpose " + SUP.ExposureInterval + " sec.";
                        expProg = SUP.ExposureProgress;
                    }
                }
            }
        }
        
        //
        // Per MaxIm docs, temp readout is valid only if these are true
        // SLEAZE: Setpoint = 20 is same as off
        //
        if(Camera.CanSetTemperature)
        {
            imgTempVis = true;
            if(Camera.CoolerOn && Camera.TemperatureSetpoint != 20) {
                var p;
                try {
                    p = Camera.CoolerPower;
                } catch(ex) {
                    if(Prefs.PointingUpdates.Simulate)
                        p = 85;
                    else
                        p = null;
                }
                try {                                                       // Handle buggy camera drivers
                    var z = Camera.Temperature;
                    if(z < 100.0) {
                        imgTemp = "@an" + Util.FormatVar(Camera.Temperature, "0") + "C";   // OK, can get temp
                        if(p) imgTemp += "/" + Util.FormatVar(p, "0") + "%";
                    }
                } catch(ex) { }
                imgTempLabel = "<a href=\"javascript:;\" id=\"sm_camTempLink\" op=\"temp\" " +
                            "title=\"Click to change cooler temp or shut down\">Cooler</a>";
            } else {
                imgTemp = "@wnOff";
                imgTempLabel = "<a href=\"javascript:;\" id=\"sm_camTempLink\" op=\"on\" " +
                            "title=\"Click to turn on cooler\">Cooler</a>";
            }
        }
        
        if(Prefs.Autoguiding.Enabled) {
            guideVis = true;
            // Do not read guide errors here until exposure is active!
            // If you do, you risk timing problems with guider startup
            // or settling monitoring in AcquireSupport!
            if(SUP && SUP.ExposureActive && SUP.Guiding) {
                gex = Camera.GuiderXError;
                gey = Camera.GuiderYError;
                if(Prefs.PointingUpdates.Simulate) {
                    gex *= 3;
                    gey *= 3;
                }
                guideStat = "@afGuiding";
                guideErrX = "@an" + Util.FormatVar(gex, "0.00");
                guideErrY = "@an" + Util.FormatVar(gey, "0.00");
                guideInt = "@an" + Util.FormatVar(SUP.GuiderInterval, "0.00");
            } else {
                guideStat = "@anIdle";
            }
        } else if(SUP && SUP.ExposureActive && SUP.Guiding) { // #autoguide directive with Prefs.Autoguiding.Enabled = false
            gex = Camera.GuiderXError;
            gey = Camera.GuiderYError;
            if(Prefs.PointingUpdates.Simulate) {
                gex *= 3;
                gey *= 3;
            }
            guideVis = true;                            // Pops into view
            guideStat = "@afGuiding";
            guideErrX = "@an" + Util.FormatVar(gex, "0.00");
            guideErrY = "@an" + Util.FormatVar(gey, "0.00");
            guideInt = "@an" + Util.FormatVar(SUP.GuiderInterval, "0.00");
        }
    }
    //
    // Activity, Plan, thumbnail, script error, and final JPEG
    //
    // The logic here for detecting a plan ending is to set isPlanRunning
    // in Session only after SUP becomes valid and we see the script is
    // AcquireImages. Unless the latter is true, the SUP is being used
    // by some utility script. Then later, when SUP once again becomes 
    // invalid, and if isPlanRunning is true, this is a positive indication 
    // that a real observing run ended. The same sort of logic applies
    // to scriptEnded, but the session isScriptRunning is set in the 
    // acquire handlers right after running a script.
    //
    // NOTE: The track error graph is 158 pixels wide. We'll use 158 pixels
    // for the actual graph. The jQuery sparkline assumes 2 pixels per value,
    // so 79 values will use 158 pixels. At 6 seconds per refresh here, that
    // ends up being about 8 minutes of history. Just about right.
    //
    // The Activity and Plan areas are combined here for historical reasons.
    // The variable hnames should help sort this out.
    //
    var planEnded = false;
    var scriptEnded = false;
    
    var actStat ="@anIdle";
    var plnHdr = "Plan";                                                    // Start with these defaults.
    var plnSet = "@in-/-";
    var plnTgt = "@inn/a (-/-)";
    var plnRpt = "@in-/-";
    var plnFilt = "@inn/a (-/-)";
    var plnCnt = "@in-/-";
    var lastFWHM = "@in-.-";                                                // Assume no FWHM, only under specific condx is available.
    var MAXTRKPTS = 79;                                                     // Max number of points in the track error graph
    var trkGraphX = "";
    var trkGraphY = "";
    var trkGraphXY = "";
    var trkGraphVis = Prefs.Autoguiding.Enabled;
    var plnIsScheduler = false;
    var plnStartNew = false;                                                // True when starting a new ACP run
    
    //
    // Manage the logic for scriptEnded and planEnded. These are used
    // later for various things like JPEG display and error popup.
    //
    if(SUP) 
    {
        //
        // Here. we know that a script is really running, as it takes 
        // some time for SUP to become active in the script.
        //
        if(Session("isObservingScript") != "yes") {                         // Skip if we already saw running plan
            if(scriptName == "AcquireImages" || scriptName == "AcquireScheduler") {
                Session("isObservingScript") = "yes";                       // This is really a plan!
                plnStartNew = true;                                         // Used to clear any lightbox
            }
        }
        //
        // Acquire support is initialized. This is used not only for observing
        // but by some utility scripts. We need to adjust the display accordingly.
        //
        if(SUP.AutoFocusActive)                                             // Regardless of state, diisplay AF info
        {
            //
            // PROCESSING FOR AUTOFOCUS (ACP and Scheduler)
            //
            actStat = "@afAutoFocus";
            plnTgt = "@anFocus Star";
        } 
        else if(Session("isObservingScript") == "yes")  // SUP is active AND running AcquireImages or AcquireScheduler
        {
            //
            // SUP is active, differentiate between observing (AcquireXxx)
            // and other scripts that may be using SUP (utilities). If running
            // a plan from a web form, there will be no sets/repeats, so just
            // leave n/a there.
            //
            try 
            {                                                       // Catch startup condition
                if(scriptName == "AcquireImages")
                {
                    //
                    // PROCESSING FOR ACQUIREIMAGES (ACP Live)
                    //
                    plnIsScheduler = false;
                    var formPlan;
                    if(Util.Script.planName == "last-plan-from-web.txt") {
                        plnHdr = "Plan from Form";
                        formPlan = true;
                    } else {
                        plnHdr = "Plan \"" + FSO.GetBaseName(Util.Script.planName) + "\"";
                        formPlan = false;
                    }
                    if(!formPlan && Util.Script.curSet != undefined)
                        plnSet = "@an" + Util.Script.curSet + "/" + Util.Script.maxSet;
                    if(Util.Script.targetName != undefined) {
                        plnTgt = "@an" + Util.Script.targetName;
                        if(!formPlan) 
                            plnTgt += " (" + Util.Script.curTarget + "/" + 
                               Util.Script.maxTarget + ")";
                    }
                    if(Util.Script.curImgSet != undefined)
                        plnFilt = "@an" + Util.Script.curFilter + " (" + 
                               Util.Script.curImgSet + "/" + 
                               Util.Script.maxImgSet + ")";
                    }
                else                                                            // Nusat be AcquireScheduler
                {
                    //
                    // PROCESSING FOR ACQUIRESCHEDULER (Scheduler)
                    //
                    plnIsScheduler = true;
                    plnHdr = "ACP Scheduler";
                    plnSet = "@an" + limitString(Util.Script.planName, 12);
                    plnTgt = "@an" + limitString(Util.Script.obsName + " ", 10) + "(" + 
                                Util.Script.curObs + "/" +  // Eat space to allow 10 chars
                                Util.Script.MaxObs + ")";
                    if(Util.Script.imgSetName != undefined)
                        plnFilt = "@an" + limitString(Util.Script.imgSetName + " ", 10) + "(" + 
                               Util.Script.curImgSet + "/" + 
                               Util.Script.maxImgSet + ")";
                    }
                //
                // PROCESSING COMMON TO BOTH ACQUIRE SCRIPTS
                //
                if(Util.Script.isPointing != undefined && Util.Script.isPointing)
                    actStat = "@afPointing Update";
                else
                    actStat = "@anObserving";
                if(!formPlan && Util.Script.curRepeat != undefined)
                    plnRpt = "@an" + Util.Script.curRepeat + "/" + Util.Script.maxRepeat;
                if(Util.Script.curCount != undefined)
                    plnCnt = "@an" + Util.Script.curCount + "/" + Util.Script.maxCount;
                if(Util.Script.lastFWHM != undefined && Util.Script.lastFWHM > 0)   // Will be junk till first data image solve
                    lastFWHM = "@an" + Util.FormatVar(Util.Script.lastFWHM, "0.0");
                //
                // Tracking error graphs... Use arrays in AcquireSupport, implement
                // a silo (last in first out) for these values. Show it any time
                // guiding is active (whether AG is enabled in ACP or not)
                //
                // Do not read guide errors here until exposure is active!
                // If you do, you risk timing problems with guider startup
                // or settling monitoring in AcquireSupport!
                //
                if(SUP && SUP.ExposureActive && SUP.Guiding)
                {
                    trkGraphVis = true;                                 // In case pop-up for #autoguide directive
                    SUP.CaptureAGErrors(MAXTRKPTS);                     // Read guider errors into the silo
                    trkGraphX = SUP.AGErrorListX;                       // Get comma-delimited error value lists
                    trkGraphY = SUP.AGErrorListY;
                    trkGraphXY = SUP.AGErrorListXY;
                }
            } catch(ex) { }                                             // Oops, leave defaults above
        }
        else if(scriptName.toLowerCase() == "autoflat")
        {
            //
            // PROCESSING FOR AUTOFLAT (ACP and Scheduler)
            //
            if(Util.Script.PlanName.substr(0, 7).toLowerCase() == "default")
                plnHdr = "Standard Flats";
            else
                plnHdr = "Flats: " & Util.Script.PlanName;
            actStat = "@an" + Util.Script.FlatState;
            if(Util.Script.FlatMode != undefined)
                plnTgt = "@an" + Util.Script.FlatMode + " Flats";
            if(Util.Script.CurFlatNum != undefined)
            {
                plnFilt = "@an" + Util.Script.CurFilter + " (" + 
                        Util.Script.CurFiltNum + "/" + 
                        Util.Script.MaxFiltNum + ")";
                plnCnt = "@an" + Util.Script.CurFlatNum + "/" +
                        Util.Script.MaxFlatNum;
            }
        }
        else                                                                // Some utility script that is using SUP
        {
            actStat = "@afUtility Script";
            plnTgt = "@af" + scriptName;
        }
    } 
    else 
    {
        //
        // No AcquireSupport (yet). This could mean the system is idle, or that
        // a script that is about to fire up AcquireSupport (SUP) is running but
        // has not yet gotte that fer. Furthermore, the script that's about to 
        // use SUP could either be AcquireImages (observing) or some other script
        // which we consider a utility. Adjust the display accordingly.
        //
        if(scrAct)
        {
            Session("isScriptRunning") = "yes";                             // Reaffirm script really running (see below)
            //
            // Here, differentiate between a plan that is starting but has
            // not yet created SUP, and some utility script that may or may
            // not be about to use SUP.
            //
            if(scriptName == "AcquireImages" || scriptName == "AcquireSupport") {
                actStat = "@anObserving";                                   // Starting to observe
            } else {
                actStat = "@afUtility Script";
                plnTgt = "@af" + scriptName;
            }
        } else {
            //
            // There is no timing window for isPlanRunning because it 
            // is triggered by the existence of SUP, but...
            //
            if(Session("isObservingScript") == "yes") {                         // Plan just ended
                planEnded = true;
                Session("isObservingScript") = "no";
                scriptEnded = true;
                Session("isScriptRunning") = "no";                          // We really know a script ended too
            }
            // ... there is a timing window for isScriptRunning since
            // one could have just been started, and has not yet gotten
            // going. So we to a 2-phase test here to give starting 
            // scripts at least one full status update cycle (6 sec.) 
            // to get running. This is a bit confusing, but the idea is
            // to test to see if isScriptRunning = yes with a script not
            // running (could be startup or shutdown) then declare it
            // "maybe" running. If we get here twice in a row with scrAct
            // false, only then declare that the script has ended. One
            // last tidbit: If we declare that a plan ended above, we also
            // declare that the script ended. This prevents planEnded from
            // being true while scriptEnded is still false (due to the 
            // 2-phase logic), and lets the LightBox alerts below work 
            // properly
            //
            if(Session("isScriptRunning") == "yes") {
                Session("isScriptRunning") = "maybe";
            } else {
                if(Session("isScriptRunning") == "maybe") {
                    scriptEnded = true;
                    Session("isScriptRunning") = "no";
                }
            }
        }
    }
    
    //
    // Smart thumbnail processing. Send a new link only if the file has changed.
    // If no (larger) ~lastimage stuff exists, don't hyperlink the thumbnail 
    // preview, otherwise link to pop up the lightbox.
    //
    // The tricky thing here is the use of the image last-modified time, converted
    // to a giant number, and added as a query string to the image URL. This was 
    // needed to force the browser to actually get a new image under the AJAX 
    // scenario. The refresh of the item won't requery images via if-modified-since.
    // the other cool thing is that it allows the image to be re-fetched if the
    // item is closed and reopened.
    //
    var lszStrm, xs, ys;
    var prevFolder = Server.MapPath("/images");
    
    var thumbnail = null;                                                   // [sentinel]
    var prevPath = prevFolder + "\\pvimage.png";
    if(FSO.FileExists(prevPath)) {
        var prevFile = FSO.GetFile(prevPath);
        if(FSO.FileExists(prevFolder + "\\lastimage.png") && FSO.FileExists(prevFolder + "\\lastimage.txt")) {
            lszStrm = FSO.OpenTextFile(prevFolder + "\\lastimage.txt");  // Dimensions file
            xs = lszStrm.ReadLine();
            ys = lszStrm.ReadLine();
            lszStrm.Close();
            // The quoting in this is really crazy, but if you study it a bit it does make sense.
            // Javascript provides the second level of unescaping for the \\' quotes!
            thumbnail = "<a href=\"javascript:;\" onClick=\"DC3.LightBox.showContent('" +
                        "<img src=\\'/images/lastimage.png?" + new Date().getTime() + 
                        "\\' width=\\'" + xs + "\\' height=\\'" + ys + "\\' alt=\\'last image\\'>" +
                        "');\">" + 
                        "<img src=\"/images/pvimage.png?" + 
                         Date.parse(prevFile.DateLastModified) + "\"></a>";
        }
        else
        {
            thumbnail = "<img src=\"/images/pvimage.png?" + 
                         Date.parse(prevFile.DateLastModified) + "\">";
        }
    }

    var guideThumb = null;                                                   // [sentinel]
    var tboxPath = prevFolder + "\\guidePreviewTBox.png";
    if(FSO.FileExists(tboxPath)) {
        var tboxFile = FSO.GetFile(tboxPath);
        if(FSO.FileExists(prevFolder + "\\guidePreviewFull.png") && FSO.FileExists(prevFolder + "\\guidePreviewDims.txt")) {
            lszStrm = FSO.OpenTextFile(prevFolder + "\\guidePreviewDims.txt");  // Dimensions file
            xs = lszStrm.ReadLine();
            ys = lszStrm.ReadLine();
            lszStrm.Close();
            // The trackbox thumbnails are 32x32 so the 48x48 below actually magnifies the image 50%
            guideThumb = "<a href=\"javascript:;\" onClick=\"DC3.LightBox.showContent('" +
                        "<img src=\\'/images/guidePreviewFull.png?" + new Date().getTime() + 
                        "\\' width=\\'" + xs + "\\' height=\\'" + ys + "\\' alt=\\'guider image\\'>" +
                        "');\">" + 
                        "<img id=\"sm_guideBox\" width=\"48\" height=\"48\" src=\"/images/guidePreviewTBox.png?" + 
                         Date.parse(tboxFile.DateLastModified) + "\"></a>";
        }
        else
        {
            guideThumb = "<img src=\"/images/guidePreviewTBox.png?" + 
                         Date.parse(tboxFile.DateLastModified) + "\">";
        }
    }

    //
    // Construct & send JSON
    //
    var JSON = "_s('sm_local','"         + escape(obsLoc)           + "');";    // Protect against embedded ' and "
    JSON += "_s('sm_utc','"              + escape(obsUTC)           + "');";
    JSON += "_s('sm_lst','"              + escape(obsST)            + "');";
    JSON += "_s('sm_obsStat','"          + escape(obsStat)          + "');";
    JSON += "_s('sm_obsOwner','"         + escape(obsOwner)         + "');";
    JSON += "_s('sm_obsOwnerLabel','"    + escape(obsOwnerLabel)    + "');";
    JSON += "_s('sm_obsShutter','"       + escape(obsShutter)       + "');";
    JSON += "_s('sm_obsShutterLabel','"  + escape(obsShutterLabel)  + "');";
    JSON += "_s('sm_obsDome','"          + escape(obsDome)          + "');";
    JSON += "_s('sm_obsDomeLabel','"     + escape(obsDomeLabel)     + "');";
    JSON += "_s('sm_obsWeather','"       + escape(obsWeather)       + "');";
    JSON += "_s('sm_obsWeatherLabel','"  + escape(obsWeatherLabel)  + "');";
    JSON += "_s('sm_scopeHdr','"         + escape(scopeHdr)         + "');";
    JSON += "_s('sm_scopeStat','"        + escape(scopeStat)        + "');";
    JSON += "_s('sm_ra','"               + escape(scopeRA)          + "');";
    JSON += "_s('sm_dec','"              + escape(scopeDec)         + "');";
    JSON += "_s('sm_pa','"               + escape(rotPA)            + "');";
    JSON += "_s('sm_az','"               + escape(scopeAz)          + "');";
    JSON += "_s('sm_alt','"              + escape(scopeAlt)         + "');";
    JSON += "_s('sm_gem','"              + escape(scopeGEM)         + "');";
    JSON += "_s('sm_air','"              + escape(scopeAirMass)     + "');";
    JSON += "_s('sm_camHdr','"           + escape(camHdr)           + "');";
    JSON += "_s('sm_camStat','"          + escape(camStat)          + "');";
    JSON += "_s('sm_imgFilt','"          + escape(imgFilt)          + "');";
    JSON += "_s('sm_imgBin','"           + escape(imgBin)           + "');";
    JSON += "_s('sm_imgTemp','"          + escape(imgTemp)          + "');";
    JSON += "_s('sm_imgTempLabel','"     + escape(imgTempLabel)     + "');";
    JSON += "_s('sm_guideStat','"        + escape(guideStat)        + "');";
    JSON += "_s('sm_guideX','"           + escape(guideErrX)        + "');";
    JSON += "_s('sm_guideY','"           + escape(guideErrY)        + "');";
    JSON += "_s('sm_guideInt','"         + escape(guideInt)         + "');";
    JSON += "_s('sm_actStat','"          + escape(actStat)          + "');";
    JSON += "_s('sm_plnTitle','"         + escape(plnHdr)           + "');";
    JSON += "_s('sm_plnSet','"           + escape(plnSet)           + "');";
    JSON += "_s('sm_plnTgt','"           + escape(plnTgt)           + "');";
    JSON += "_s('sm_plnRpt','"           + escape(plnRpt)           + "');";
    JSON += "_s('sm_plnFilt','"          + escape(plnFilt)          + "');";
    JSON += "_s('sm_plnCnt','"           + escape(plnCnt)           + "');";
    JSON += "_s('sm_trkGraphX','"        + escape(trkGraphX)        + "');";
    JSON += "_s('sm_trkGraphY','"        + escape(trkGraphY)        + "');";
    JSON += "_s('sm_trkGraphXY','"       + escape(trkGraphXY)       + "');";
    JSON += "_s('sm_lastFWHM','"         + escape(lastFWHM)         + "');";
    if(thumbnail !== null)                                                      // Only if there is one
        JSON += "_s('sm_thumb','"        + escape(thumbnail)        + "');";
    else
        JSON += "_s('sm_thumb','"        + ""                       + "');";
    if(guideThumb !== null)                                                     // Only if there is one
        JSON += "_s('sm_guideImg','"     + escape(guideThumb)       + "');";
    else
        JSON += "_s('sm_guideImg','"     + ""                       + "');";
    if(plnIsScheduler) {
        JSON += "_s('sm_plnSetLabel','"  + "Plan"                   + "');";
        JSON += "_s('sm_plnTgtLabel','"  + "Obs"                    + "');";
        JSON += "_s('sm_plnFiltLabel','" + "ImgSet"                 + "');";
    } else {
        JSON += "_s('sm_plnSetLabel','"  + "Set"                    + "');";
        JSON += "_s('sm_plnTgtLabel','"  + "Target"                 + "');";
        JSON += "_s('sm_plnFiltLabel','" + "Filter"                 + "');";
    }    
        
    JSON += "_v('sm_obsShutterRow',"     + obsShutterVis            + ");";
    JSON += "_v('sm_obsDomeRow',"        + obsDomeVis               + ");";
    JSON += "_v('sm_paRow',"             + rotVis                   + ");";
    JSON += "_v('sm_gemRow',"            + gemVis                   + ");";
//      JSON += "_v('sm_imgFiltRow',"        + imgFiltVis               + ");";
    JSON += "_v('sm_imgTempRow',"        + imgTempVis               + ");";
    JSON += "_v('sm_imgGuiderRow1',"     + guideVis                 + ");";
    JSON += "_v('sm_imgGuiderRow2',"     + guideVis                 + ");";
    JSON += "_v('sm_imgGuiderRow3',"     + guideVis                 + ");";
    JSON += "_v('sm_imgGuiderRow4',"     + guideVis                 + ");";
    JSON += "_v('sm_imgGuiderRow5',"     + guideVis                 + ");";
//      JSON += "_v('sm_plnFiltRow',"        + plnFiltVis               + ");";
    JSON += "_v('sm_imgGraphArea',"      + trkGraphVis              + ");";
    
    
    JSON += "_p('sm_slewProg',"          + slewProg                 + ");";     // This is the fractional value
    JSON += "_p('sm_expProg',"           + expProg                  + ");";     // Client JS renders the bars
    
    if(plnStartNew) {    
        JSON += "_lh();";
        plnStartNew = false;                                            // just once
    }
    //
    // Smart refresh of console log text. Only if there is an active script
    // or if the browser sent a query string of 'init'.
    //
    var consText = Console.Text(100);                                   // Needed for error test too
    if(Session("lastConsLines") == Console.Text(3)) {                   // If console contents haven't changed
        if(Request.ServerVariables("QUERY_STRING").toLowerCase() == 'init')     // If client specifically asks for console
            JSON += "_c('@n" + escape(consText) + "');";                // But don't scroll to bottom
    } else {
        JSON += "_c('@s" + escape(consText) + "');";                    // Busy, refresh and scroll to bottom
    }
    Session("lastConsLines") = Console.Text(3);
    //
    // If this is the observatory owner (only) report some status
    // if a script/plan just ended, or get input for the console.
    // NOTE: The logic above for detecting planEnded and scriptEnded
    // assure that if planEnded is true, that scriptEnded is also 
    // true.
    //
    // GEM:256 Won't show if "Release obs when script ends" is set as there  will be
    // no Lock.Owner!
    //
//  if(Lock.Owner == User.Name)
//  {
        switch(Console.WebMode)
        {
            case WebNormal:
                //
                // ORDER BELOW IS CRITICAL!
                //
                // Detect a script error. Takes precedence over plan ended.
                //
                if(scriptEnded && (consText.search(/\*\*Script Error/img) != -1)) 
                {
                    if(consText.search(/The script was [interrupted|aborted]/img) != -1) {
                        JSON += "_a('warning', '" + escape("You interrupted the script.") + "');";
                    } else {
                        JSON += "_a('error', '" + escape("There was a problem with the run. Check the Run Log for details.") + "');";
                    }
                }
                //
                // Handle successful end of Plan
                //
                else if(planEnded)
                {
                    var lstPath = prevFolder + "\\~lastimage.png";
                    if(FSO.FileExists(lstPath)) {                           // prevFolder already from above
                        var lstFile = FSO.GetFile(lstPath);                 // File info for lastimage
                        var dStrm = FSO.OpenTextFile(prevFolder + "\\~lastimage.txt");  // This has image dimensions in it (GEM:254)
                        var xSize = dStrm.ReadLine();
                        var ySize = dStrm.ReadLine();
                        dStrm.Close();
                        // See notes above on use of last-modified date as uniquifying query string
                        JSON += "_l(\"<img src='/images/" + User.Username + "/~lastimage.png?" + 
                            Date.parse(lstFile.DateLastModified) + 
                            "' width='" + xSize + "' height='" + ySize + "' alt='last image'>\");";
                    } else {
                        JSON += "_a('info', '" + escape("The observing run has completed.") + "');";
                    }
                }
                //
                // Handle compilation error or successful script end.
                //
                else if(scriptEnded)
                {
                    if(FSO.GetBaseName(Console.Script) == "AcquireImages" && consText.search(/ending due to plan errors/img) != -1) {
                        JSON += "_a('error', '" + escape("The observing plan failed to compile. Check the Run Log for details.") + "');";
                    } else {
                        JSON += "_a('ok', '" + escape("The " + FSO.GetBaseName(Console.Script) + 
                                        " script has completed successfully. Check the Run Log for details.") + "');";
                    }
                }
                break;
            case WebAskYesNoWait:
                JSON += "_y(\"" + escape(Console.WebPrompt) + "\");";
                break;
            case WebReadLineWait:
                JSON += "_r(\"" + escape(Console.WebPrompt) + "\", " + 
                            (Console.WebButtons == consOKCancel) + ");";
                break;
            case WebAlertWait:
                var icon;
                switch(Console.WebIcon) {
                    case consIconInfo:     icon = "info";     break;
                    case consIconQuestion: icon = "question"; break;
                    case consIconWarning:  icon = "warning";  break;
                    case consIconError:    icon = "error";    break;
                    case consIconOK:       icon = "ok";       break;
                    default:               icon = "info";     break;        // Punt on this
                }
                JSON += "_aw('" + icon + "', '" + escape(Console.WebPrompt) + "');";
                break;
            default:
                break;
        }
//  }

    Response.Write(JSON);                                                   // Send the executable JS to the client
    FSO = null;

</script>
