<%@LANGUAGE="JSCRIPT"%><%
	//
	// Generate a weather snapshot - manual refresh
	//
	// 06-Nov-06	rbd	Initial edit
	//
	
	Response.ContentType = "text/plain";									// Plain text -> wikitext
	if(!Weather.Available) {
		Response.Write("Weather is not available.\n\n");
		Response.End();
	}
	//
	// We have a weather server and it's connected
	//
// ----------------------------------AAG modifications BEGIN
//	Response.Write("The items and values shown are those supported by the @@" +  Weather.Name + "@@ sensor. " + 
//			"If you have a Boltwood Cloud Sensor II, see the [[CloudSensor II]] item for more info.\n");

	Response.Write("<html><p>The items and values shown are supplied by the " +  Weather.Name + " weather server for AAG_CloudWatcher.</p></html>" +
									"Also see [[AAG_WeatherControl]] for more info.\n");
// ----------------------------------AAG modifications END
	Response.Write("|Status|" + (Weather.Safe ? "@@background:green;color:black;Safe@@|\n" : "@@background:red;color:black;Unsafe@@|\n"));
	try {
		Response.Write("|Clouds|" + Util.FormatVar(Weather.Clouds * 100, "0") + " %");
		try {
			Response.Write(Weather.Precipitation ? " (Rain)|\n" : "|\n");
		} catch(ex) { 
			Response.Write("|\n");
		}
	} catch(ex) { }
	try {
		Response.Write("|Wind|from " + Util.FormatVar(Weather.WindDirection, "000") + 
						" at " + Util.FormatVar(Weather.WindVelocity, "0") + " Kt" + "|\n");
	} catch(ex) { 
		try {
			Response.Write("|Wind|from " +  Util.FormatVar(Weather.WindDirection, "000") + "|\n");
		} catch(ex) {
			try {
				Response.Write("|Wind|" + Util.FormatVar(Weather.WindVelocity, "0") + " Kt" + "|\n");
			} catch(ex) { }
		}
	}
	try {
		Response.Write("|Ambient Temperature|" + Util.FormatVar(Weather.AmbientTemperature, "0.0") + " deg C|\n");
	} catch(ex) { }
	try {
		Response.Write("|Dew Point|" + Util.FormatVar(Weather.DewPoint, "0.0") + " deg C|\n");
	} catch(ex) { }
	try {
		Response.Write("|Relative Humidity|" + Util.FormatVar(Weather.RelativeHumidity * 100, "0") + " %|\n");
	} catch(ex) { }
	try {
		Response.Write("|Inside Temperature|" + Util.FormatVar(Weather.InsideTemperature, "0.0") + " deg C|\n");
	} catch(ex) { }
	try {
		Response.Write("|Barometric Pressure|" + Util.FormatVar(Weather.BarometricPressure, "0") + " mB|\n");
	} catch(ex) { }
%>